/**
* \file: common.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Rexaline Xavier  /  RexalineInfancia.Xavier@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/

#ifndef COMMON_H
#define COMMON_H

#define CLIENT_ALD_PROTOCOL_MAJOR_VERSION					1
#define CLIENT_ALD_PROTOCOL_MINOR_VERSION					0

#include "ald_types.h"
#include "app_iface/generated/ald-dbus-interface.h"

extern const char *error_code_strings[];

error_code_t common_init(void);

void common_deinit(void);


error_code_t common_connect_ALD(Change_level **change_level_iface);

void common_disconnect_ald(Change_level **change_level_iface);

void common_initialize_response(challenge_response_t *response, security_level_t target_level, const char *serial);

error_code_t common_get_challenge_and_add_to_response(Change_level *change_level_iface,challenge_response_t *response,const char *ecu_id);

error_code_t common_calculate_signature(const char *levelprivkey_path,challenge_response_t *response);

error_code_t common_send_response(Change_level *change_level_iface,challenge_response_t *response);

error_code_t common_lock_device(Change_level *change_level_iface);

#endif /* COMMON_H */
